﻿using Hims.Shared.EntityModels;

using System.Collections.Generic;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    /// <summary>
    /// The employee shifts Service interface.
    /// </summary>
    public interface IEmployeeShiftService
    {
        /// <summary>
        /// The add employee shifts async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(EmployeeShiftModel model);

        /// <summary>
        /// The update employee shifts async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(EmployeeShiftModel model);

        /// <summary>
        /// The change employee shifts status async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ChangeStatusAsync(EmployeeShiftModel model);

        /// <summary>
        /// The fetch employee shifts async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<EmployeeShiftModel>> FetchAsync(EmployeeShiftFilterModel model);
    }
}
