﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.PatientExcel;
    using Shared.EntityModels;
    using Shared.UserModels.UserExcel;

    /// <summary>
    /// The user excel upload history service interface.
    /// </summary>
    public interface IPatientExcelHistoryService
    {
        /// <summary>
        /// The modify excel upload async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> ModifyExcelUploadAsync(PatientExcelHistoryModel model);

        /// <summary>
        /// The fetch all async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<PatientExcelHistoryModel>> FetchAllAsync(PatientExcelHistoryModel model);

        /// <summary>
        /// The get single excel history.
        /// </summary>
        /// <param name="userExcelHistoryId">
        /// The excel upload history id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<PatientExcelHistoryModel> GetSingleExcelHistory(int userExcelHistoryId);
    }
}
