﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    using Hims.Shared.UserModels.Filters;

    /// <summary>
    /// The ILabOrderValue Service interface.
    /// </summary>
    public interface IRadiologyValueService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<RadiologyValueModel>> FetchAsync(RadiologyValueFilterModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(RadiologyValueModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(RadiologyValueModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="radiologyValueId">
        /// The generalAdvice id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int radiologyValueId);

        /// <summary>
        /// The get delete async in provider encounter.
        /// </summary>
        /// <param name="radiologyValueId">
        /// The generalAdvice id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> updateProviderEncounterAsync(int radiologyValueId);
    }
}
