﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.UserModels.UnitType;

    /// <inheritdoc />
    public class UnitTypeService : IUnitTypeService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IUnitTypeService" />
        public UnitTypeService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model)
        {
            var where = " WHERE 1 = 1 ";
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += $@" AND TRIM(UPPER(""Name"")) = '{model.Name.Trim().ToUpper()}'";
            }

            //if (model.Active != null)
            //{
            //    where += $@" AND ""Active"" IS {((bool)model.Active ? "TRUE" : "FALSE")}";
            //}

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", * FROM ""UnitType"" {where} Order by ""UnitTypeId"" DESC";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<ViewModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<ViewModel>(query);
        }

        /// <inheritdoc />
        public async Task<int> AddAsync(InsertModel model)
        {
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""UnitTypeId"") FROM ""UnitType"" WHERE TRIM(UPPER(""Name"")) = '{model.Name.ToUpper().Trim()}'");
            if (checkIf > 0)
            {
                return -1;
            }

            var unitType = new UnitType
            {
                Name = model.Name,
                Min = model.Min,
                Max = model.Max,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now,
            };

            return await this.unitOfWork.UnitType.InsertAsync(unitType);
        }

        /// <inheritdoc />
        public async Task<int> UpdateAsync(UpdateModel model)
        {
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""UnitTypeId"") FROM ""UnitType"" WHERE TRIM(UPPER(""Name"")) = '{model.Name.ToUpper().Trim()}' AND ""UnitTypeId"" <> {model.UnitTypeId}");
            if (checkIf > 0)
            {
                return -1;
            }

            var unitType = await this.unitOfWork.UnitType.FindAsync(m => m.UnitTypeId == model.UnitTypeId);
            unitType.Name = model.Name;
            unitType.ModifiedBy = model.ModifiedBy;
            unitType.ModifiedDate = DateTime.Now;
            return await this.unitOfWork.UnitType.UpdateAsync(unitType);
        }

        /// <inheritdoc />
        public async Task<int> DeleteAsync(DeleteModel id)
        {
            var response = await this.unitOfWork.UnitType.DeleteAsync(x => x.UnitTypeId == id.UnitTypeId);
            return response ? 1 : -1;
        }

        public async Task<string> FindNameByUnitTypeId(int id)
        {
            var query = $@"SELECT ""Name"" FROM ""UnitType"" WHERE ""UnitTypeId"" = {id}";
            var response = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<string>(query);
            return response;
        }

    }
}