﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class DashboardConfigModel
    {
        /// <summary>
        /// Gets or sets the config id.
        /// </summary>
        public int? DashboardConfigId { get; set; }

        /// <summary>
        /// Gets or sets the dashboard configuration master identifier.
        /// </summary>
        /// <value>
        /// The dashboard configuration master identifier.
        /// </value>
        public int DashboardConfigMasterId { get; set; }

        /// <summary>
        /// Gets or sets the widget id.
        /// </summary>
        public int DashboardWidgetId { get; set; }

        /// <summary>
        /// Gets or sets the dashboard widget type identifier.
        /// </summary>
        /// <value>
        /// The dashboard widget type identifier.
        /// </value>
        public int DashboardWidgetTypeId { get; set; }

        /// <summary>
        /// Gets or sets the dashboard widget count type identifier.
        /// </summary>
        /// <value>
        /// The dashboard widget count type identifier.
        /// </value>
        public int? DashboardWidgetCountTypeId { get; set; }

        /// <summary>
        /// Gets or sets the row number.
        /// </summary>
        /// <value>
        /// The row number.
        /// </value>
        public int RowNumber { get; set; }

        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        /// <value>
        /// The size.
        /// </value>
        public int Size { get; set; }

        /// <summary>
        /// Gets or sets the sequence number.
        /// </summary>
        /// <value>
        /// The sequence number.
        /// </value>
        public int SequenceNumber { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the Log From.
        /// </summary>
        public short? LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the Log From.
        /// </summary>
        public string? WidgetName { get; set; }

        /// <summary>
        /// Gets or sets the name of the stored procedure.
        /// </summary>
        /// <value>
        /// The name of the stored procedure.
        /// </value>
        public string? StoredProcedureName { get; set; }

        /// <summary>
        /// Gets or sets the name of the count type.
        /// </summary>
        /// <value>
        /// The name of the count type.
        /// </value>
        public string? CountTypeName { get; set; }

        /// <summary>
        /// Gets or sets the icon.
        /// </summary>
        /// <value>
        /// The icon.
        /// </value>
        public string? Icon { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is role dashboard.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is role dashboard; otherwise, <c>false</c>.
        /// </value>
        public bool IsRoleDashboard { get; set; }

        /// <summary>
        /// Gets or sets the default values.
        /// </summary>
        /// <value>
        /// The default values.
        /// </value>
        public string DefaultValues { get; set; }
    }
}
