﻿using System;

namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The appointment.
    /// </summary>
    public class NurseModel
    {
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the name of the role.
        /// </summary>
        /// <value>
        /// The name of the role.
        /// </value>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the general date.
        /// </summary>
        /// <value>
        /// The general date.
        /// </value>
        public DateTime GeneralDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the shift.
        /// </summary>
        /// <value>
        /// The name of the shift.
        /// </value>
        public string ShiftName { get; set; }

        /// <summary>
        /// Gets or sets the shift identifier.
        /// </summary>
        /// <value>
        /// The shift identifier.
        /// </value>
        public int ShiftId { get; set; }

        /// <summary>
        /// Gets or sets the shift identifier.
        /// </summary>
        /// <value>
        /// The shift identifier.
        /// </value>
        public int NurseShiftMapId { get; set; }

        /// <summary>
        /// Gets or sets the account encrypt identifier.
        /// </summary>
        /// <value>
        /// The account encrypt identifier.
        /// </value>
        public string AccountEncryptId { get; set; }

        /// <summary>
        /// Gets or sets the bed ids.
        /// </summary>
        /// <value>
        /// The bed ids.
        /// </value>
        public int[] BedIds { get; set; }

        /// <summary>
        /// Gets or sets the account identifier.
        /// </summary>
        /// <value>
        /// The account identifier.
        /// </value>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail URL.
        /// </summary>
        /// <value>
        /// The thumbnail URL.
        /// </value>
        public string ThumbnailUrl { get; set; }
    }
}
