﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The patient document.
    /// </summary>
    public class PaymentDocumentModel
    {
        /// <summary>
        /// Gets or sets the patient document id.
        /// </summary>
        public int PaymentDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the uploaded by name.
        /// </summary>
        public string? UploadedByName { get; set; }

        /// <summary>
        /// Gets or sets the uploaded by role.
        /// </summary>
        public string? UploadedByRole { get; set; }

        /// <summary>
        /// Gets or sets the document name.
        /// </summary>
        public string DocumentName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the document type.
        /// </summary>
        public string DocumentType { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the content type.
        /// </summary>
        public string ContentType { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        public float Size { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the document url.
        /// </summary>
        public string DocumentUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string ThumbnailUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the uploaded date.
        /// </summary>
        public DateTime UploadedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether IsRead.
        /// </summary>
        public bool IsRead { get; set; }

        /// <summary>
        /// Gets or sets the month.
        /// </summary>
        public string? Month { get; set; }

        /// <summary>
        /// Gets or sets the year.
        /// </summary>
        public string? Year { get; set; }

    }
}
