﻿using System.Collections.Generic;

namespace Hims.Shared.EntityModels
{
    using System;
    using Library.Enums;

    /// <summary> The chat.</summary>
    public class TimelineModel
    {
        /// <summary>
        /// Gets or sets the timeline id.
        /// </summary>
        public int TimelineId { get; set; }

        /// <summary>
        /// Gets or sets the timeline action id.
        /// </summary>
        public TimelineAction TimelineActionId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the ids.
        /// </summary>
        public List<int> Ids { get; set; }

        /// <summary>
        /// Gets or sets the data.
        /// </summary>
        public string Data { get; set; }
    }
}
