﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class WardModel
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int WardId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the floor id.
        /// </summary>
        public int FloorId { get; set; }

        /// <summary>
        /// Gets or sets the floor.
        /// </summary>
        public string FloorName { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or Sets the Modified By Name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }
        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }


        /// <summary>
        /// Gets or sets the location id.
        /// Used to know whether used want to update status or not ; default is false 
        /// </summary>
        public Boolean updateStatus { get; set; }
    }
}
