﻿namespace Hims.Shared.UserModels.ChargeModule
{
    using System.Collections.Generic;

    /// <summary>
    /// The charge module insertion model.
    /// </summary>
    public class ChargeModuleInsertionModel
    {
        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int ModulesMasterId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the charge module template identifier.
        /// </summary>
        /// <value>
        /// The charge module template identifier.
        /// </value>
        public int ChargeModuleTemplateId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the charges.
        /// </summary>
        /// <value>
        /// The charges.
        /// </value>
        public List<ChargeDetailModel> Charges { get; set; }
    }

    /// <summary>
    /// The charge detail model
    /// </summary>
    public class ChargeDetailModel
    {
        /// <summary>
        /// Gets or sets the charge module details identifier.
        /// </summary>
        /// <value>
        /// The charge module details identifier.
        /// </value>
        public int? ChargeModuleDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the reference identifier.
        /// </summary>
        /// <value>
        /// The reference identifier.
        /// </value>
        public int ReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double Amount { get; set; }
    }
}
