﻿#nullable enable
using System;

namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The patient filter model.
    /// </summary>
    public class PatientFilterModel
    {
        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
#pragma warning disable CS8618 // Non-nullable field is uninitialized. Consider declaring as nullable.
        public string AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string? AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int? TotalAdmissions { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string Age { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string AdmissionTimeString { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string AappointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public TimeSpan AappointmentTime { get; set; }


        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public string AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string? Email { get; set; }


        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string? UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string FromDate { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public int? TotalAppointments { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the ward name .
        /// </summary>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the room name .
        /// </summary>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the bed no.
        /// </summary>
        public string BedNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public string CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public string RoleId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the discharge status identifier.
        /// </summary>
        public int? DischargeStatusId { get; set; }
        /// <summary>
        /// Gets or sets the referrred by.
        /// </summary>
        public string? ReferredBy { get; set; }
        /// <summary>
        /// Gets or sets the referrred by name.
        /// </summary>
        public string? ReferredByName { get; set; }

        /// <summary>
        /// Gets or sets the Location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the HWC patient identifier.
        /// </summary>
        public int? HWCPatientId { get; set; }


    }
}
