﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    using System;

    /// <summary>
    /// The user filter model.
    /// </summary>
    public class UserFilterModel
    {
        /// <summary>
        /// Gets or sets the user id.
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string? Email { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public char? Status { get; set; }

        /// <summary>
        /// Gets or sets the last login date.
        /// </summary>
        public DateTime? LastLoginDate { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }
        /// <summary>
        /// Gets or sets the  location id.
        /// </summary>
        public int? LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the  user name.
        /// </summary>
        public string? Username { get; set; }

        /// <summary>
        /// Gets or sets the  bulk user ids.
        /// </summary>
        public string? BulkUserIds { get; set; }
    }
}
