﻿namespace Hims.Shared.UserModels.MasterBill
{
    using System;
    /// <summary>
    /// The receipt model
    /// </summary>
    public class FilterModel

    {
       
        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }       

        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int? ReceiptAreaTypeId { get; set; }       

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string BillNumber { get; set; }   

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string FromDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string ToDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the location
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the service from date.
        /// </summary>
        public string ServiceFromDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the service to date.
        /// </summary>
        public string ServiceToDate { get; set; } = string.Empty;

    }
}
