﻿namespace Hims.Shared.UserModels.OperationTheater
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The ot issue model.
    /// </summary>
    public class OTIssueModel
    {
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the operation indent header identifier.
        /// </summary>
        /// <value>
        /// The operation indent header identifier.
        /// </value>
        public int OperationIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the indent header id.
        /// </summary>
        public int? IndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the issue header id.
        /// </summary>
        public int? IssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy identifier.
        /// </summary>
        /// <value>
        /// The retail pharmacy identifier.
        /// </value>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the indent header identifier.
        /// </summary>
        /// <value>
        /// The indent header identifier.
        /// </value>
        public int? ProductId { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<OTProductsModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public short RoleId { get; set; }
        /// <summary>
        /// Gets or sets the indent header id.
        /// </summary>
        public int? Cnt { get; set; }

        /// <summary>
        /// Gets or sets the Product.
        /// </summary>
        /// <value>
        ///The Product.
        /// </value>
        public string? Product { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        /// <value>
        /// The type.
        /// </value>
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }
        /// <summary>
        /// Gets or sets the FromDate.
        /// </summary>
        /// <value>
        /// FromDate.
        /// </value>
        public string? FromDate { get; set; }
        /// <summary>
        /// Gets or sets the ToDate.
        /// </summary>
        /// <value>
        /// TheToDate.
        /// </value>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the inventory ware house identifier.
        /// </summary>
        /// <value>
        /// The inventory ware house identifier.
        /// </value>
        public int? InventoryWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the inventory department identifier.
        /// </summary>
        /// <value>
        /// The inventory department identifier.
        /// </value>
        public int? InventoryDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the hand over to.
        /// </summary>
        /// <value>
        /// The hand over to.
        /// </value>
        public int? HandOverTo { get; set; }
    }
}
