﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Shared.UserModels.OrderPrescription
{

    /// <summary>
    /// The common response.
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the order prescription identifier.
        /// </summary>
        /// <value>
        /// The order prescription identifier.
        /// </value>
        public int ValueId { get; set; }

        /// <summary>
        /// Gets or sets the order master id.
        /// </summary>
        /// <value>
        /// The name of the order master id.
        /// </value>
        public int OrderPrescriptionMasterId { get; set; }

        /// <summary>
        /// Gets or sets the value name.
        /// </summary>
        /// <value>
        /// The value name.
        /// </value>
        public string ValueName { get; set; }
        
        /// <summary>
        /// Gets or sets the value name.
        /// </summary>
        /// <value>
        /// The value name.
        /// </value>
        public string Type { get; set; }
        
        /// <summary>
        /// Gets or sets the value name.
        /// </summary>
        /// <value>
        /// The value name.
        /// </value>
        public string OrderName { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets modified by name.
        /// </summary>
        /// <value>
        /// The modified by name.
        /// </value>
        public string ModifiedByName { get; set; }
        
        /// <summary>
        /// Gets or sets created by name.
        /// </summary>
        /// <value>
        /// The modified by name.
        /// </value>
        public string createdByName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        public string? SearchParam { get; set; }

        /// <summary>
        /// Gets or sets encounter type id.
        /// </summary>
        public int? EncounterTypeId { get; set; }
        /// <summary>
        /// Gets or sets the provider id
        /// </summary>
        public int ProviderId { get; set; }
        /// <summary>
        /// Gets or sets the provider id
        /// </summary>
        public string? Name { get; set; }

        public string? EncounterName { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int PageSize { get; set; }
        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items
        /// </value>

        public int? TotalItems { get; set; }

    }

    public class OrderPrescriptionMasterModel
    {
        /// <summary>
        /// Gets or sets the value id.
        /// </summary>
        public int? OrderPrescriptionMasterId { get; set; }

        /// <summary>
        /// Gets or sets the value name.
        /// </summary>
        public string? Name { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
         
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the created by Name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
       
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets the modified by Name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the encounter type id.
        /// </summary>
        public int? EncounterTypeId { get; set; }
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }
        /// <summary>
        /// Gets or sets encounter name
        /// </summary>
        public string? EncounterName { get; set; }
        /// <summary>
        /// Gets or sets encounter name
        /// </summary>
        public string? ProviderName { get; set; }

        public int? TotalItems { get; set; }
        public int PageIndex { get; set; }
        public int PageSize { get; set; }


        public int LoginRoleId { get; set; }
    }
}
