﻿namespace Hims.Shared.UserModels.PatientMedication
{
    using System;

    /// <summary>
    /// The patient medication detail model.
    /// </summary>
    public class PatientMedicationDetailModel
    {
        /// <summary>
        /// Gets or sets the patient medication detail identifier.
        /// </summary>
        /// <value>
        /// The patient medication detail identifier.
        /// </value>
        public int PatientMedicationDetailId { get; set; }

        /// <summary>
        /// Gets or sets the patient lab detail identifier.
        /// </summary>
        /// <value>
        /// The patient lab detail identifier.
        /// </value>
        public int PatientLabDetailId { get; set; }

        /// <summary>
        /// Gets or sets the patient medication header identifier.
        /// </summary>
        /// <value>
        /// The patient medication header identifier.
        /// </value>
        public int PatientMedicationHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        /// <value>
        /// The duration.
        /// </value>
        public int Duration { get; set; }

        /// <summary>
        /// Gets or sets the dosage.
        /// </summary>
        /// <value>
        /// The dosage.
        /// </value>
        public int Dosage { get; set; }

        /// <summary>
        /// Gets or sets the type of the duration.
        /// </summary>
        /// <value>
        /// The type of the duration.
        /// </value>
        public string DurationType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is morning.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is morning; otherwise, <c>false</c>.
        /// </value>
        public bool IsMorning { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is afternoon.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is afternoon; otherwise, <c>false</c>.
        /// </value>
        public bool IsAfternoon { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is night.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is night; otherwise, <c>false</c>.
        /// </value>
        public bool IsNight { get; set; }

        /// <summary>
        /// Gets or sets the morning dosage.
        /// </summary>
        /// <value>
        /// The morning dosage.
        /// </value>
        public string MorningDosage { get; set; }

        /// <summary>
        /// Gets or sets the afternoon dosage.
        /// </summary>
        /// <value>
        /// The afternoon dosage.
        /// </value>
        public string AfternoonDosage { get; set; }

        /// <summary>
        /// Gets or sets the night dosage.
        /// </summary>
        /// <value>
        /// The night dosage.
        /// </value>
        public string NightDosage { get; set; }

        /// <summary>
        /// Gets or sets the instruction.
        /// </summary>
        /// <value>
        /// The instruction.
        /// </value>
        public string Instruction { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the company identifier.
        /// </summary>
        /// <value>
        /// The company identifier.
        /// </value>
        public int CompanyId { get; set; }

        /// <summary>
        /// Gets or sets the category identifier.
        /// </summary>
        /// <value>
        /// The category identifier.
        /// </value>
        public int CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the name of the category.
        /// </summary>
        /// <value>
        /// The name of the category.
        /// </value>
        public string CategoryName { get; set; }
        /// <summary>
        /// Gets or sets the afternoon dosage.
        /// </summary>
        /// <value>
        /// The afternoon dosage.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the route.
        /// </summary>
        /// <value>
        /// The route.
        /// </value>
        public string Route { get; set; }

        /// <summary>
        /// Gets or sets the name of the sale unit.
        /// </summary>
        /// <value>
        /// The name of the sale unit.
        /// </value>
        public string SaleUnitName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string? Remark { get; set; }
    }
}
