﻿using System;

namespace Hims.Shared.UserModels.Pharmacy
{
    /// <summary>
    /// The med frequency master model.
    /// </summary>
    public class MedFrequencyMasterModel
    {
        /// <summary>
        /// Gets or sets the med frequency master identifier.
        /// </summary>
        /// <value>
        /// The med frequency master identifier.
        /// </value>
        public int MedFrequencyMasterId { get; set; }

        /// <summary>
        /// Gets or sets the name of the frequency.
        /// </summary>
        /// <value>
        /// The name of the frequency.
        /// </value>
        public string FrequencyName { get; set; }

        /// <summary>
        /// Gets or sets the frequency description.
        /// </summary>
        /// <value>
        /// The frequency description.
        /// </value>
        public string FrequencyDescription { get; set; }

        /// <summary>
        /// Gets or sets the type of the freq.
        /// </summary>
        /// <value>
        /// The type of the freq.
        /// </value>
        public string FreqType { get; set; }

        /// <summary>
        /// Gets or sets the calculation unit.
        /// </summary>
        /// <value>
        /// The calculation unit.
        /// </value>
        public int CalculationUnit { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="MedFrequencyMasterModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }
    }
}
