﻿namespace Hims.Shared.UserModels
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics.CodeAnalysis;

    /// <summary>
    /// The provider shift model.
    /// </summary>
    public class PharmacyIndentsModel
    {
        /// <summary>
        /// Gets or sets the day.
        /// </summary>
        public int PharmacyIndentDtlId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent hdr id.
        /// </summary>
        public int PharmacyIndentHdrId { get; set; }

        /// <summary>
        /// Gets or sets the consultation charges.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public int PharmacyVatTaxId { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public DateTime IndentDate { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public string ReasonForRequirement { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public string MrpChangeReason { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int TotalItems { get; set; }

    }

    
}
