﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.ProgressReport.Medication
{
    using System;

    /// <summary>
    /// The receipt model
    /// </summary>
    public class InsertModel
    {
        public int AdmissionId { get; set; }

        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }


        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public string? modifiedBy { get; set; }
        /// <summary>
        /// Gets or Sets the Provider Id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the records.
        /// </summary>
        /// <value>
        /// The records.
        /// </value>
        public List<InsertModelHelper> Records { get; set; }


    }



    /// <summary>
    /// The receipt model
    /// </summary>
    public class InsertModelHelper
    {
        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the unit.
        /// </summary>
        /// <value>
        /// The unit.
        /// </value>
        public float Unit { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        /// <value>
        /// The duration.
        /// </value>
        public int Duration { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        public DateTime EndDate { get; set; }

        /// <summary>
        /// Gets or sets the medication duration type identifier.
        /// </summary>
        /// <value>
        /// The medication duration type identifier.
        /// </value>
        public int MedicationDurationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the medication instructions.
        /// </summary>
        /// <value>
        /// The medication instructions.
        /// </value>
        public List<int> MedicationInstructions { get; set; }
        /// <summary>
        /// Gets or sets the medication instructions.
        /// </summary>
        /// <value>
        /// The medication instructions.
        /// </value>
        public List<int> TimeLineId { get; set; }

        /// <summary>
        /// Gets or sets the instructions.
        /// </summary>
        /// <value>
        /// The instructions.
        /// </value>
        public string Instructions { get; set; }

    }


}
