﻿namespace Hims.Shared.UserModels.ProgressReport.Notes
{
    using System;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int ProgressReportNoteId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int ProgressReportId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public DateTime Date { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string Note { get; set; }
        
        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        /// <value>
        /// The salutation.
        /// </value>
        public string Salutation { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the patient image.
        /// </summary>
        /// <value>
        /// The patient image.
        /// </value>
        public string PatientImage { get; set; }
    }
}
