﻿
namespace Hims.Shared.UserModels.ProviderSchedule
{

    using System;
    using System.Collections.Generic;
    /// <summary>
    /// The coupon.
    /// </summary>
    public class FilterModel
    {
        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public string? ProviderId { get; set; }

        /// <summary>
        /// gets or sets the specialization Id.
        /// </summary>
        public string? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the consultation type id.
        /// </summary>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the expiry.
        /// </summary>
        /// <value>
        /// The date.
        /// </value>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the slot tat.
        /// </summary>
        public string? SlotTat { get; set; }

        /// <summary>
        /// Gets or sets the slot duration.
        /// </summary>
        public int? SlotDuration { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public bool? AppointmentStatus { get; set; }

        /// <summary>
        /// Gets or sets the appointment Date.
        /// </summary>
        public string AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment End Date;
        /// </summary>
        public string? AppointmentEndDate { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the calendar view.
        /// </summary>
        public string? CalendarView { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        public List<AppFilterModel> Filter { get; set; }
    }

    /// <summary>
    /// The appointment filter model.
    /// </summary>
    public class AppFilterModel
    {
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the Visit type.
        /// </summary>
        public int? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string? AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string? Status { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string? UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the is follow up appointment.
        /// </summary>
        public string? IsFollowUpAppointment { get; set; }

        /// <summary>
        /// Gets or sets the queue status.
        /// </summary>
        /// <value>
        /// The queue status.
        /// </value>
        public int QueueStatusId { get; set; }
        /// <summary>
        /// Gets or sets the age
        /// </summary>
        /// <value>
        /// The age status.
        /// </value>
        public int? Age { get; set; }
        /// <summary>
        /// Gets or sets the mobile
        /// </summary>
        /// <value>
        /// The Mobile Number.
        /// </value>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or setst the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the consultation type id.
        /// </summary>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Get or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        public string ModifiedByRole { get; set; }
    }

}

