﻿namespace Hims.Shared.UserModels.Receipt
{
    /// <summary>
    /// The receipt model
    /// </summary>
    public class FilterModel
    {
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }
        /// <summary>
        /// Gets or sets the identifier.
        /// </summary>
        /// <value>
        /// The identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [active only].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [active only]; otherwise, <c>false</c>.
        /// </value>
        public bool ActiveOnly { get; set; }

        /// <summary>
        /// Gets or sets the receipt identifier.
        /// </summary>
        /// <value>
        /// The receipt identifier.
        /// </value>
        public int? ReceiptId { get; set; }
    }
}
