﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.ServiceOrder
{
    using System;

    public class InsertHelperModel
    {
        public int? ServiceOrderId { get; set; }

        public int ChargeId { get; set; }

        public int Unit { get; set; }

        public double Cost { get; set; }

        public int? ChargeTypeId { get; set; }

        public int? ChargeTypeMainId { get; set; }

        public int? AdmissionPackageId { get; set; }

        public int? PackageModuleDetailId { get; set; }

        public int? UsedQuantity { get; set; }

        public double? UsedCost { get; set; }

        public string Notes { get; set; }

        public bool Active { get; set; }
        public DateTime CreatedDate { get; set; }

        public string DiscountType { get; set; }
        public double? DiscountPercentage { get; set; }
        public double? DiscountAmount { get; set; }
        public double? Discount { get; set; }
    }

    public class InsertLabServiceHelperModel
    {
        public int? LabServicesId { get; set; }
        public int LabMainDetailId { get; set; }

        public int LabHeaderId { get; set; }

        public DateTime? LabDate { get; set; }

        public int ChargeCategoryId { get; set; }

        public int Unit { get; set; }

        public double Cost { get; set; }

        public string Notes { get; set; }

        public bool Active { get; set; }

        public int? AdmissionPackageId { get; set; }

        public int? PackageModuleDetailId { get; set; }

        public int? UsedQuantity { get; set; }

        public double? UsedCost { get; set; }

        public DateTime CreatedDate { get; set; }
        public string DiscountType { get; set; }
        public double? DiscountPercentage { get; set; }
        public double? DiscountAmount { get; set; }
        public double? Discount { get; set; }

    }

    public class InsertSurgeryHelperModel
    {
        public int? SurgeryServiceId { get; set; }

        public int ChargeId { get; set; }

        public int Unit { get; set; }

        public double Cost { get; set; }

        public int? ChargeTypeId { get; set; }

        public int? ChargeTypeMainId { get; set; }

        public int? AdmissionPackageId { get; set; }

        public int? PackageModuleDetailId { get; set; }

        public int? UsedQuantity { get; set; }

        public double? UsedCost { get; set; }

        public string Notes { get; set; }

        public bool Active { get; set; }
        public DateTime CreatedDate { get; set; }

        public int? SurgeryId { get; set; }

        public int? ChargeCategoryId { get; set; }
    }

    public class InsertScanHelperModel
    {
        public int? ScanServiceId { get; set; }

        public int ChargeId { get; set; }

        public int Unit { get; set; }

        public double Cost { get; set; }

        public int? ChargeTypeId { get; set; }

        public int? ChargeTypeMainId { get; set; }

        public int? AdmissionPackageId { get; set; }

        public int? PackageModuleDetailId { get; set; }

        public int? UsedQuantity { get; set; }

        public double? UsedCost { get; set; }

        public string Notes { get; set; }

        public bool Active { get; set; }
        public DateTime CreatedDate { get; set; }

        public int? ScanTestMasterId { get; set; }

        public int? ChargeCategoryId { get; set; }
    }

    public class InsertModel
    {
        public List<InsertHelperModel> Records { get; set; }

        public List<InsertLabServiceHelperModel> LabServices { get; set; }

        public List<InsertSurgeryHelperModel> SurgeryServices { get; set; }

        public List<InsertScanHelperModel> ScanServices { get; set; }

        public List<int> Packages { get; set; }

        public int CreatedBy { get; set; }

        public int AdmissionId { get; set; }

        public string Id { get; set; }

        public bool IsAdmission { get; set; }

        public short? RoleId { get; set; }

        public string RollName { get; set; }

        public string FullName { get; set; }

        public string Notes { get; set; }

        public int? LocationId { get; set; }
        public bool? ReceiptSaving { get; set; }
    }
}
