﻿using System;
namespace Hims.Shared.UserModels.Vaccine
{
    public class VaccineMasterModel
    {
        /// <summary>
        /// Gets or sets the vaccine master identifier.
        /// </summary>
        /// <value>
        /// The vaccine master identifier.
        /// </value>
        public int VaccineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the vaccine group identifier.
        /// </summary>
        /// <value>
        /// The vaccine group identifier.
        /// </value>
        public int VaccineGroupId { get; set; }

        /// <summary>
        /// Gets or sets the name of the vaccine group.
        /// </summary>
        /// <value>
        /// The name of the vaccine group.
        /// </value>
        public string VaccineGroupName { get; set; }

        /// <summary>
        /// Gets or sets the name of the vaccine.
        /// </summary>
        /// <value>
        /// The name of the vaccine.
        /// </value>
        public string VaccineName { get; set; }

        /// <summary>
        /// Gets or sets the display name.
        /// </summary>
        /// <value>
        /// The display name.
        /// </value>
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the vaccine instruction.
        /// </summary>
        /// <value>
        /// The vaccine instruction.
        /// </value>
        public string VaccineInstruction { get; set; }

        /// <summary>
        /// Gets or sets the order.
        /// </summary>
        /// <value>
        /// The order.
        /// </value>
        public int Order { get; set; }

        /// <summary>
        /// Gets or sets the vaaccine type identifier.
        /// </summary>
        /// <value>
        /// The vaaccine type identifier.
        /// </value>
        public int VaccineTypeId { get; set; }

        /// <summary>
        /// Gets or sets the allowed days.
        /// </summary>
        /// <value>
        /// The allowed days.
        /// </value>
        public double AllowedDays { get; set; }

        /// <summary>
        /// Gets or sets the type of the allowed.
        /// </summary>
        /// <value>
        /// The type of the allowed.
        /// </value>
        public string AllowedType { get; set; }

        /// <summary>
        /// Gets or sets the exclusion days.
        /// </summary>
        /// <value>
        /// The exclusion days.
        /// </value>
        public string ExclusionDays { get; set; }

        /// <summary>
        /// Gets or sets the allowed laps days.
        /// </summary>
        /// <value>
        /// The allowed laps days.
        /// </value>
        public int? AllowedLapsDays { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets the color of the row.
        /// </summary>
        /// <value>
        /// The color of the row.
        /// </value>
        public string RowColor { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        /// <value>
        /// The active.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the scheduled date.
        /// </summary>
        /// <value>
        /// The scheduled date.
        /// </value>
        public DateTime? ScheduledDate { get; set; }

        /// <summary>
        /// Gets or sets the allowed laps date.
        /// </summary>
        /// <value>
        /// The allowed laps date.
        /// </value>
        public DateTime? AllowedLapsDate { get; set; }

        /// <summary>
        /// Gets or sets the vaccine age group identifier.
        /// </summary>
        /// <value>
        /// The vaccine age group identifier.
        /// </value>
        public int VaccineAgeGroupId { get; set; }

        /// <summary>
        /// Gets or sets the name of the age group.
        /// </summary>
        /// <value>
        /// The name of the age group.
        /// </value>
        public string AgeGroupName { get; set; }

        /// <summary>
        /// Gets or sets the immunization.
        /// </summary>
        /// <value>
        /// The immunization.
        /// </value>
        public ImmunizationHistoryModel Immunization {  get; set; }
    }
}
