﻿using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.Vaccine
{
    /// <summary>
    /// The vaccine pharmacy link header model.
    /// </summary>
    public class VaccinePharmacyLinkHeaderModel
    {
        /// <summary>
        /// Gets or sets the vaccine pharmacy link header identifier.
        /// </summary>
        /// <value>
        /// The vaccine pharmacy link header identifier.
        /// </value>
        public int VaccinePharmacyLinkHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the vaccines.
        /// </summary>
        /// <value>
        /// The vaccines.
        /// </value>
        public List<VaccinePharmacyLinkDetailModel> Vaccines { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the expert advice.
        /// </summary>
        /// <value>
        /// The expert advice.
        /// </value>
        public string ExpertAdvice { get; set; }

        /// <summary>
        /// Gets or sets the common side effects.
        /// </summary>
        /// <value>
        /// The common side effects.
        /// </value>
        public string CommonSideEffects { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }
    }

    /// <summary>
    /// The vaccine pharmacy link detail model
    /// </summary>
    public class VaccinePharmacyLinkDetailModel
    {
        /// <summary>
        /// Gets or sets the vaccine pharmacy link detail identifier.
        /// </summary>
        /// <value>
        /// The vaccine pharmacy link detail identifier.
        /// </value>
        public int VaccinePharmacyLinkDetailId { get; set; }

        /// <summary>
        /// Gets or sets the vaccine pharmacy link header identifier.
        /// </summary>
        /// <value>
        /// The vaccine pharmacy link header identifier.
        /// </value>
        public int VaccinePharmacyLinkHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the vaccine master identifier.
        /// </summary>
        /// <value>
        /// The vaccine master identifier.
        /// </value>
        public int VaccineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the name of the vaccine.
        /// </summary>
        /// <value>
        /// The name of the vaccine.
        /// </value>
        public string VaccineName { get; set; }

        /// <summary>
        /// Gets or sets the display name.
        /// </summary>
        /// <value>
        /// The display name.
        /// </value>
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the type of the allowed.
        /// </summary>
        /// <value>
        /// The type of the allowed.
        /// </value>
        public string AllowedType { get; set; }

        /// <summary>
        /// Gets or sets the name of the age group.
        /// </summary>
        /// <value>
        /// The name of the age group.
        /// </value>
        public string AgeGroupName { get; set; }

        /// <summary>
        /// Gets or sets the allowed days.
        /// </summary>
        /// <value>
        /// The allowed days.
        /// </value>
        public int AllowedDays { get; set; }

        /// <summary>
        /// Gets or sets the grouped vaccines.
        /// </summary>
        /// <value>
        /// The grouped vaccines.
        /// </value>
        public string GroupedVaccines { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }
    }
}
