﻿namespace Hims.Shared.UserModels.Vendors
{
    using System;

    /// <summary>
    /// The purchase order header.
    /// </summary>    
    public class PurchaseOrderHeaderModel
    {
        /// <summary>
        /// Gets or sets the purchase order header identifier.
        /// </summary>
        /// <value>
        /// The purchase order header identifier.
        /// </value>
        public long PurchaseOrderHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the po number.
        /// </summary>
        /// <value>
        /// The po number.
        /// </value>
        public string PONumber { get; set; }

        /// <summary>
        /// Gets or sets the purchase order header ids.
        /// </summary>
        /// <value>
        /// The purchase order header ids.
        /// </value>
        public string PurchaseOrderHeaderIds { get; set; }

        /// <summary>
        /// Gets or sets the po raise date.
        /// </summary>
        /// <value>
        /// The po raise date.
        /// </value>
        public DateTime PORaiseDate { get; set; }

        /// <summary>
        /// Gets or sets the estimated delivery date.
        /// </summary>
        /// <value>
        /// The estimated delivery date.
        /// </value>
        public DateTime? EstimatedDeliveryDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the tender status identifier.
        /// </summary>
        /// <value>
        /// The tender status identifier.
        /// </value>
        public int TenderStatusId { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the total tax.
        /// </summary>
        /// <value>
        /// The total tax.
        /// </value>
        public double TotalTax { get; set; }

        /// <summary>
        /// Gets or sets the total net amount.
        /// </summary>
        /// <value>
        /// The total net amount.
        /// </value>
        public double TotalNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the due days.
        /// </summary>
        /// <value>
        /// The due days.
        /// </value>
        public int? DueDays { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the central warehouse location identifier.
        /// </summary>
        /// <value>
        /// The central warehouse location identifier.
        /// </value>
        public int? CentralWarehouseLocationId { get; set; }


        /// <summary>
        /// Gets or sets the name of the supplier.
        /// </summary>
        /// <value>
        /// The name of the supplier.
        /// </value>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string WareHouseName { get; set; }
        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the type of the bill.
        /// </summary>
        /// <value>
        /// The type of the bill.
        /// </value>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        /// <value>
        /// The bill date.
        /// </value>
        public DateTime? BillDate { get; set; }

        /// <summary>
        /// Gets or sets the due date.
        /// </summary>
        /// <value>
        /// The due date.
        /// </value>
        public DateTime? DueDate { get; set; }

        /// <summary>
        /// Gets or sets the bill amount.
        /// </summary>
        /// <value>
        /// The bill amount.
        /// </value>
        public double? BillAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        /// <value>
        /// The discount.
        /// </value>
        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the taxes.
        /// </summary>
        /// <value>
        /// The taxes.
        /// </value>
        public double? Taxes { get; set; }

        /// <summary>
        /// Gets or sets the netamount.
        /// </summary>
        /// <value>
        /// The netamount.
        /// </value>
        public double? Netamount { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy purchase header identifier.
        /// </value>
        public int? PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the source.
        /// </summary>
        /// <value>
        /// The source.
        /// </value>
        public string Source { get; set; }

        /// <summary>
        /// Gets or sets the total bill count.
        /// </summary>
        /// <value>
        /// The total bill count.
        /// </value>
        public int? TotalBillCount { get; set; }
    }
}
