﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;
#nullable enable
namespace Hims.Domain.Entities
{
    public class AdmissionBedChangeRequest
    {
        /// <summary>
        /// Gets or sets the admission bed change request identifier.
        /// </summary>
        /// <value>
        /// The admission bed change request identifier.
        /// </value>
        [Key, Identity]
        public int AdmissionBedChangeRequestId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the request comments.
        /// </summary>
        /// <value>
        /// The request comments.
        /// </value>
        public string? RequestComments { get; set; }

        /// <summary>
        /// Gets or sets the charge categories.
        /// </summary>
        /// <value>
        /// The charge categories.
        /// </value>
        public Array? ChargeCategories { get; set; } = null;

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="AdmissionBedChangeRequest"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
    }
}
