﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider encounter.
    /// </summary>
    public class ProviderEncounter
    {
        /// <summary>
        /// Gets or sets the provider general advice id.
        /// </summary>
        [Key, Identity]
        public int ProviderGeneralAdviceId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the general advice id.
        /// </summary>
        public string? GeneralAdviceIds { get; set; }

        /// <summary>
        /// Gets or sets the icd id.
        /// </summary>
        public string? ICDIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for reactions.
        /// </summary>
        public string? ReactionIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for hospitalization.
        /// </summary>
        public string? HospitalizationIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for pcare.
        /// </summary>
        public string? PCareIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for initial.
        /// </summary>
        public string? InitialIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for site.
        /// </summary>
        public string? SiteIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for vaccine.
        /// </summary>
        public string? VaccineIds { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the lab order value ids.
        /// </summary>
        public string? LabOrderValueIds { get; set; }

        /// <summary>
        /// Gets or sets the radiology value ids.
        /// </summary>
        public string? RadiologyValueIds { get; set; }

        /// <summary>
        /// Gets or sets the lookup value ids for allergy.
        /// </summary>
        public string? AllergyIds { get; set; }
    }
}
