﻿namespace Hims.Domain.Services
{
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels;
    using Shared.EntityModels;

    /// <summary>
    /// The health card Service interface.
    /// </summary>
    public interface IHealthCardService
    {

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(HealthCardModel model);

        /// <summary>
        /// update  asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(HealthCardModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<HealthCardModel>> FetchAllAsync(HealthCardModel model);

        /// <summary>
        /// Activates the or deactivate card.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateCard(HealthCardModel model);


        /// <summary>
        /// fetch all issued card.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<HealthCardHolderModel>> FetchAllIssuedCard(HealthCardHolderModel model);

        /// <summary>
        /// add new card.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddNewCardAsync(HealthCardHolderModel model);
        /// <summary>
        /// fetch card beneficiary.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PatientModel>> FetchCardBeneficiariesAsync(HealthCardHolderModel model);

        /// <summary>
        /// check health card.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<HealthCardHolderModel>> CheckHealthCardForPatient(HealthCardHolderModel model);
        Task<IEnumerable<HealthCardHolderModel>> FetchPatientIssuedCard(int PatientId);
    }
}
