﻿namespace Hims.Shared.Dapper.SqlGenerator
{
    /// <summary>
    /// Class that models the data structure in converting the expression tree into SQL and Params.
    /// </summary>
    public class QueryParameter
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="QueryParameter" /> class.
        /// </summary>
        /// <param name="linkingOperator">The linking operator.</param>
        /// <param name="propertyName">Name of the property.</param>
        /// <param name="propertyValue">The property value.</param>
        /// <param name="queryOperator">The query operator.</param>
        /// <param name="nestedProperty">Signalize if it is nested property.</param>
        public QueryParameter(string linkingOperator, string propertyName, object propertyValue, string queryOperator, bool nestedProperty)
        {
            this.LinkingOperator = linkingOperator;
            this.PropertyName = propertyName;
            this.PropertyValue = propertyValue;
            this.QueryOperator = queryOperator;
            this.NestedProperty = nestedProperty;
        }

        /// <summary>
        /// Gets or sets the linking operator.
        /// </summary>
        public string LinkingOperator { get; set; }

        /// <summary>
        /// Gets or sets the property name.
        /// </summary>
        public string PropertyName { get; set; }

        /// <summary>
        /// Gets or sets the property value.
        /// </summary>
        public object PropertyValue { get; set; }

        /// <summary>
        /// Gets or sets the query operator.
        /// </summary>
        public string QueryOperator { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether nested property.
        /// </summary>
        public bool NestedProperty { get; set; }
    }
}