﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The insurance company.
    /// </summary>
    public class InsuranceCompanyModel
    {
        /// <summary>
        /// Gets or sets the insurance company id.
        /// </summary> 
        public int InsuranceCompanyId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the country code.
        /// </summary>
        public string CountryCode { get; set; }

        /// <summary>
        /// Gets or sets the country name.
        /// </summary>
        public string CountryName { get; set; }

        /// <summary>
        /// Gets or sets the contact person name.
        /// </summary>
        public string ContactPersonName { get; set; }

        /// <summary>
        /// Gets or sets the contact period from.
        /// </summary>
        public DateTime ContactPeriodFrom { get; set; }

        /// <summary>
        /// Gets or sets the contact period to.
        /// </summary>
        public DateTime ContactPeriodTo { get; set; }

        /// <summary>
        /// Gets or sets the contact person mobile.
        /// </summary>
        public string ContactPersonMobile { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the AccountFullName .
        /// </summary>
        public string? ModifiedByName { get; set; }
    }
}
