﻿namespace Hims.Shared.EntityModels
{
   
    using System;
    using System.ComponentModel.DataAnnotations;
    using Hims.Shared.Dapper.Attributes;
    /// <summary>
    /// The coupon.
    /// </summary>
    public class ProviderScheduleChargesModel
    {
        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        [Key, Identity]
        public int ProviderScheduleChargesId { get; set; }

        /// <summary>
        /// Gets or sets the visitor name.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the visit type for.
        /// </summary>
        public int SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or Sets the modified By Name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or Sets the careted By Name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the specialization charge.
        /// </summary>
        public string? SpecializationCharge { get; set; }

        /// <summary>
        /// Gets or sets the specializaton name.
        /// </summary>
        public string? SpecializationName { get; set; }

    }
}
