﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Labs
{
    public class ExternalLabTransferUserModel
    {
        /// <summary>
        /// Gets or sets the external lab agemcy identifier.
        /// </summary>
        /// <value>
        /// The external lab agemcy identifier.
        /// </value>
        public int ExternalLabAgencyId { get; set; }

        /// <summary>
        /// Gets or sets the transfered by.
        /// </summary>
        /// <value>
        /// The transfered by.
        /// </value>
        public int TransferedBy { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the create date.
        /// </summary>
        /// <value>
        /// The create date.
        /// </value>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the labs.
        /// </summary>
        /// <value>
        /// The labs.
        /// </value>
        public List<LabTransferDetailModel> Labs { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        public string Comments { get; set; }
    }
}
