﻿using System;

namespace Hims.Shared.UserModels.MealType
{
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int MealTypeId { get; set; }

        /// <summary>
        /// Gets or sets the meal name.
        /// </summary>
        public string MealInstruction { get; set; }

        /// <summary>
        /// Gets or sets the meal name.
        /// </summary>
        public string MealType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the meal name.
        /// </summary>
        public string CreatedByName { get; set; }
        
        /// <summary>
        /// Gets or sets the meal name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public string LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationNames { get; set; }

    }
}
