﻿namespace Hims.Shared.UserModels.Menu.Relationship
{
    /// <summary> The chat.</summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the main page.
        /// </summary>
        /// <value>
        /// The main page.
        /// </value>
        public string MainPage { get; set; }

        /// <summary>
        /// Gets or sets the menu identifier.
        /// </summary>
        /// <value>
        /// The menu identifier.
        /// </value>
        public int MenuId { get; set; }

        /// <summary>
        /// Gets or sets the sub page.
        /// </summary>
        /// <value>
        /// The sub page.
        /// </value>
        public string SubPage { get; set; }

        /// <summary>
        /// Gets or sets the icon.
        /// </summary>
        /// <value>
        /// The icon.
        /// </value>
        public string Icon { get; set; }

        /// <summary>
        /// Gets or sets the URL.
        /// </summary>
        /// <value>
        /// The URL.
        /// </value>
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the name of the menu type.
        /// </summary>
        /// <value>
        /// The name of the menu type.
        /// </value>
        public int? RelationshipMenuId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        /// <value>
        /// The priority.
        /// </value>
        public int? Priority { get; set; }

        /// <summary>
        /// Gets or sets the menu type identifier.
        /// </summary>
        /// <value>
        /// The menu type identifier.
        /// </value>
        public int? MenuTypeId { get; set; }
    }
}