﻿#nullable enable
namespace Hims.Shared.UserModels.PharmacyRequest
{
    /// <summary>
    /// The pharmacy issue request.
    /// </summary>
    public class PharmacyIssueRequest
    {
        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy issue header id.
        /// </summary>
        public int PharmacyIssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent header id.
        /// </summary>
        public int PharmacyIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent detail id.
        /// </summary>
        public int PharmacyIndentDetailId { get; set; }
        
        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the gst percentage.
        /// </summary>
        public double GstPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string? ProductName { get; set; }

        /// <summary>
        /// Gets or sets the temp product name.
        /// </summary>
        public string? TempProductName { get; set; }

        /// <summary>
        /// Gets or sets the receipt identifier.
        /// </summary>
        /// <value>
        /// The receipt identifier.
        /// </value>
        public int? ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }
    }

    /// <summary>
    /// The pharmacy issue request request.
    /// </summary>
    public class PharmacyIssueRejectRequest
    {
        /// <summary>
        /// Gets or sets the pharmacy issue header id.
        /// </summary>
        public int? PharmacyIssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int? PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent header id.
        /// </summary>
        public int PharmacyIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent detail id.
        /// </summary>
        public int PharmacyIndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the ot indent header id.
        /// </summary>
        public int? OTIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string? ProductName { get; set; }

        /// <summary>
        /// Gets or sets the temp product name.
        /// </summary>
        public string? TempProductName { get; set; }
    }
}
