﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Domain.Entities;
    using Shared.UserModels.ChargeModule;

    public interface IChargeModuleService
    {
        #region Charge Templates

        Task<IEnumerable<ChargeModuleTemplateModel>> FetchChargeTemplatesAsync(ChargeTemplateFilterModel model);

        Task<int> ModifyChargeTemplateAsync(ChargeModuleTemplateModel model);

        Task<bool> SetInUseChargeTemplateAsync(ChargeModuleTemplateModel model);

        #endregion

        Task<int> ModifyChargeAsync(ChargeModuleInsertionModel model);

        Task<IEnumerable<ChargeModuleDetailsModel>> FetchGivenChargesAsync(ChargeModuleDetailsModel model);

        Task<int> DeleteChargeAsync(int chargeModuleDetailsId);

        Task<ChargeModuleDetailsModel> GetRequiredDetailForChargeFetchAsync(string moduleName, int locationId);

        Task<IEnumerable<DoctorSpecializationChargeModuleDetailsModel>> FetchDoctorSpecializationGivenChargesAsync(DoctorSpecializationChargeModuleDetailsModel model);

        Task<int> ModifyDoctorSpecializationChargeAsync(DoctorSpecializationChargeModuleInsertionModel model);

        Task<int> DeleteDoctorSpecializationChargeAsync(int deleteDoctorSpecializationChargeModuleDetailsId);

        Task<DoctorSpecializationMap> FetchOrCreateRefrenceId(DoctorSpecializationChargeModuleDetailsModel model);

        #region Update Location Charges

        Task<IEnumerable<LocationChargePriceModel>> FetchLocationChargePricesAsync(int locationId, int chargeModuleTemplateId, int modulesMasterId, int chargeReferenceId);

        Task<bool> UpdateLocationChargePricesAsync(List<ChargeModuleDetailsModel> model);

        #endregion
    }
}
