﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    using Hims.Shared.UserModels;

    /// <summary>
    /// The discount management service interface.
    /// </summary>
    public interface IModulesMasterService
    {
       // FetchModules UpdateModule         DeleteModule AddModule

        /// <summary>
        /// The add  module.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> AddModule(ModulesMasterModel model);

        /// <summary>
        /// The update  module.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> UpdateModule(ModulesMasterModel model);

        /// <summary>
        /// Fetches the modules.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ModulesMasterModel>> FetchModules(ModulesMasterModel model);
       
        /// <summary>
        /// The delete  module.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> DeleteModule(ModulesMasterModel model);
    }
}
