import { Appointment } from "../entities";
import { NotifyService } from '@shared/services';

export default class WhatsAppFunctionality {
    notifyServicee: NotifyService;
    constructor(notifyServicee: NotifyService) {
        this.notifyServicee = notifyServicee;
    }

    sendAppointmentBooking(record: Appointment) {
        const body = {};
        body['PatientMobile'] = record['patientMobile'];
        body['PatientName'] = record.patientName.length < 2 ? "**" : record.patientName;
        body['DoctorName'] = record.providerName
        body['BranchName'] = record.locationName
        body['AppointmentDate'] = record.appointmentDate
        body['AppointmentTime'] = record.appointmentTimeString
        body['PracticeName'] = record.practiceName
        body['AppointmentNo'] = record.appointmentNo
        body['ContactNumber'] = record['patientMobile'];
        console.log("The record is : ")
        fetch("https://hims.careaxes.net/whatsAppApi/sendTxtMsg", { method: "POST", body: JSON.stringify(body), headers: { "Accept": "application/json" } })
            .then(data => data.text()).then((response: any) => console.log(response))
        this.notifyServicee.successToast("Whatsapp message sent successfully");
        //console.log(record);
    }

    sendAppointmentCancel(record: Appointment) {
        const body = {};
        body['PatientMobile'] = record['patientMobile'];
        body['PatientName'] = record.patientName.length < 2 ? "**" : record.patientName;
        body['DoctorName'] = record.providerName
        body['BranchName'] = record.locationName
        body['AppointmentDate'] = record.appointmentDate
        body['AppointmentTime'] = record.appointmentTimeString
        body['PracticeName'] = record.practiceName
        body['AppointmentNo'] = record.appointmentNo
        body['ContactNumber'] = record['patientMobile'];
        fetch("https://hims.careaxes.net/whatsAppApi/Cancel", { method: "POST", body: JSON.stringify(body), headers: { "Accept": "application/json" } })
            .then(data => data.text()).then((response: any) => console.log(response))
    }

    sendAppointmentReschedule() {
        console.log("The appointment details sent")
    }

    labBooking() {
        console.log("the lab booking functionality not implemented")
    }

    labCancellation() {
        console.log("The lab cancellation func not implemented")
    }
}