﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The user excel history.
    /// </summary>
    public class PatientExcelHistory
    {
        /// <summary>
        /// Gets or sets the excel upload history id.
        /// </summary>
        [Key, Identity]
        public int PatientExcelHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the uploaded by.
        /// </summary>
        public int UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the sheet name.
        /// </summary>
        public string SheetName { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
       
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the added users.
        /// </summary>

        public string AddedPatients { get; set; }
    }
}
