﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;

    using Hims.Domain.Entities;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.OperationTheater;
    using Hims.Shared.UserModels.Pharmacy;
    using Hims.Shared.UserModels.PharmacyRequest;

    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The PharmacyService interface.
    /// </summary>
    public interface IPharmacyService
    {



     /// <summary>
     /// Gets All the Units.
     /// </summary>
     /// <returns></returns>
     Task<IEnumerable<string>> GetAllUnitTypes();


        /// <summary>
        /// The create unit async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateUnitAsync(LookupValueModel model);

        /// <summary>
        /// The create category async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateCategoryAsync(LookupValueModel model);

        /// <summary>
        /// The create rack async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateRackAsync(LookupValueModel model);

        /// <summary>
        /// Creates the lookup value asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> CreateLookupValueAsync(LookupValueModel model);

        /// <summary>
        /// The create gst async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateGstAsync(LookupValueModel model);

        /// <summary>
        /// The update lookup value async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateLookupValueAsync(LookupValueModel model);

        /// <summary>
        /// The delete lookup value async.
        /// </summary>
        /// <param name="lookupValueId">
        /// The lookup value id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteLookupValueAsync(int lookupValueId);

        /// <summary>
        /// The fetch lookup values.
        /// </summary>
        /// <param name="model">
        /// The lookup name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LookupValueModel>> FetchLookupValues(LookupValueModel model);

        /// <summary>
        /// The create pharmacy product.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreatePharmacyProduct(ProductModel model);

        /// <summary>
        /// The update pharmacy product.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdatePharmacyProduct(ProductModel model);


        /// <summary>
        /// The fetch bill number.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FetchBillNumber();

        /// <summary>
        /// The fetch pharmacy product.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProductModel>> FetchPharmacyProduct(ProductModel model);

        /// <summary>
        /// The fetch pharmacy products.
        /// </summary>      
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProductModel>> FetchPharmacyProducts();

        /// <summary>
        /// The delete pharmacy product.
        /// </summary>
        /// <param name="pharmacyProductId">
        /// The pharmacy product id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeletePharmacyProduct(int pharmacyProductId);

        /// <summary>
        /// The fetch added bill.
        /// </summary>
        /// <param name="purchaseHeaderId">
        /// The purchase header id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyBillModel>> FetchAddedBill(int purchaseHeaderId);

        /// <summary>
        /// The fetch phaemacy purchase bill.
        /// </summary>
        /// <param name="purchaseHeaderId">
        /// The purchase header id.
        /// </param>
        /// <param name="type">
        /// The purchase type.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyPurchaseBill>> FetchPharmacyPurchaseBill(int purchaseHeaderId, string type);

        /// <summary>
        /// The fetch pharmacy stocks.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyStockModel>> FetchPharmacyStocks(PharmacyStockModel model);

        /// <summary>
        /// The fetch pharmacy stocks.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyStockModel>> FetchPharmacyRetailStocks(PharmacyStockModel model);

        /// <summary>
        /// The add sale bill.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<Tuple<int, string>> AddSaleBill(PharmacySaleBillModel model);

        /// <summary>
        /// The fetch sale added bill.
        /// </summary>
        /// <param name="pharmacySaleHeaderId">
        /// The pharmacy sale header id.
        /// </param>
        /// <param name="billNumber">
        /// The bill number.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacySaleBill>> FetchSaleAddedBill(int? pharmacySaleHeaderId, string billNumber, int? locationId);

        /// <summary>
        /// The fetch sale return bill.
        /// </summary>
        /// <param name="pharmacySaleHeaderId">
        /// The pharmacy sale header id.
        /// </param>
        /// <param name="billNumber">
        /// The bill number.
        /// </param>
        /// <param name="saleReturnHeaderId">
        /// The sale return header id.
        /// </param>        
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacySaleReturnBillDetailsModel>> FetchSaleReturnDetialsBill(int? pharmacySaleHeaderId, string billNumber, int? saleReturnHeaderId);

        /// <summary>
        /// The update sale bill.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<Tuple<int, string>> UpdateSaleBill(PharmacySaleBillModel model);

        /// <summary>
        /// The add surgery kit.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddSurgeryKit(SurgeryHeaderModel model);

        /// <summary>
        /// The fetch surgery kit headers.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<SurgeryHeaderModel>> FetchSurgeryKitHeaders();

        /// <summary>
        /// The fetch surgery details.
        /// </summary>
        /// <param name="headerId">
        /// The header id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<SurgeryDetailModel>> FetchSurgeryDetails(int headerId);

        /// <summary>
        /// The update surgery kit.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateSurgeryKit(SurgeryHeaderModel model);

        /// <summary>
        /// The delete surgery kit.
        /// </summary>
        /// <param name="headerId">
        /// The header id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteSurgeryKit(int headerId);

        /// <summary>
        /// The fetch product expiry next month.
        /// </summary>
        /// <param name="locationId">
        /// The location id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyDashboardModel>> FetchProductExpiryNextMonth(int? locationId);

        /// <summary>
        /// Fetches the product expiry in next months.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDashboardModel>> FetchProductExpiryInNextMonths(PharmacyReportFilterModel model);

        /// <summary>
        /// Fetches the product expiry this month.
        /// </summary>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDashboardModel>> FetchProductExpiryThisMonth(int? locationId);

        /// <summary>
        /// The fetch product under reorder level.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyDashboardModel>> FetchProductUnderReorderLevel(PharmacyReportFilterModel model);

        /// <summary>
        /// The fetch product expiry next month retail.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyDashboardModel>> FetchProductExpiryNextMonthRetail(PharmacyReportFilterModel model);

        /// <summary>
        /// Fetches the product expiry this month retail.
        /// </summary>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDashboardModel>> FetchProductExpiryThisMonthRetail(int? locationId);

        /// <summary>
        /// The fetch product under reorder level retail.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyDashboardModel>> FetchProductUnderReorderLevelRetail(PharmacyReportFilterModel model);

        /// <summary>
        /// The add pharmacy sale bill return async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddPharmacySaleBillReturnAsync(PharmacySaleReturnBillModel model);

        /// <summary>
        /// The fetch sale return bill.
        /// </summary>
        /// <param name="id">
        /// The id.
        /// </param>
        /// <param name="billNumber">
        /// The bill number.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacySaleReturnFetchModel>> FetchSaleReturnBill(int? id, string billNumber);

        /// <summary>
        /// The add retail stock.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddRetailStock(PharmacyRetailStockModel model);

        /// <summary>
        /// The fetch surgery products stock.
        /// </summary>
        /// <param name="ids">
        /// The ids.
        /// </param>
        /// <param name="retailPharmacyId">
        /// The retail pharmacy id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyStockModel>> FetchSurgeryProductsStock(string ids, int? retailPharmacyId);

        /// <summary>
        /// The update main stock.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> UpdateMainStock(PharmacyRetailStockModel model);

        /// <summary>
        /// The update retail stock.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> UpdateRetailStock(PharmacyRetailStockModel model);

        /// <summary>
        /// The update sale bill quantity.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> UpdateSaleBillQuantity(PharmacySaleBill model);

        /// <summary>
        /// The delete sale bill item.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> DeleteSaleBillItem(PharmacySaleBill model);

        /// <summary>
        /// The cancel sale bill.
        /// </summary>
        /// <param name="saleHeaderId">
        /// The sale header id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> CancelSaleBill(int saleHeaderId);

        /// <summary>
        /// The fetch pharmacy product with retail stock async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProductModel>> FetchPharmacyProductWithRetailStockAsync(ProductModel model);

        /// <summary>
        /// The move retail stock to main async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> MoveRetailStockToMainAsync(PharmacyMoveQuantity model);

        /// <summary>
        /// The fetch purchase bill item.
        /// </summary>
        /// <param name="pharmacyStockId">
        /// The pharmacy stock id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<PharmacyPurchaseBill> FetchPurchaseBillItem(int pharmacyStockId);

        /// <summary>
        /// The return purchase bill.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> ReturnPurchaseBill(PharmacyPurchaseReturnBillModel model);

        /// <summary>
        /// Fetches the product revenue.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyExplorerModel>> FetchProductRevenue(PharmacyExplorerFilterModel model);

        /// <summary>
        /// Fetches the category revenue.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyExplorerModel>> FetchCategoryRevenue(PharmacyExplorerFilterModel model);

        /// <summary>
        /// Fetches the top products revenue.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyExplorerModel>> FetchTopProductsRevenue(PharmacyExplorerFilterModel model);

        /// <summary>
        /// Adding payment Type info to existing data in pharmacy_sale_header .
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> AddPayType(PharmacySaleBillModel model);

        /// <summary>
        /// The fetch purchase bill item.
        /// </summary>
        /// <param name="surgeryKitHeaderId">
        /// The pharmacy stock id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<string> FindKitNameBySurgeryKitHeaderId(int surgeryKitHeaderId);

        /// <summary>
        /// The fetch added purchase bill async.
        /// </summary>
        /// <param name="pharmacyPurchaseHeaderId">
        /// The pharmacy purchase header id.
        /// </param>
        /// <param name="billNumber">
        /// The bill number.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyBillModel>> FetchAddedPurchaseBillAsync(int? pharmacyPurchaseHeaderId, string billNumber);

        /// <summary>
        /// Fetches the doctor collection.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDoctorCollection>> FetchDoctorCollection(PharmacyExplorerFilterModel model);

        /// <summary>
        /// Fetches the employee collection.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyEmployeeCollection>> FetchEmployeeCollection(PharmacyExplorerFilterModel model);

        /// <summary>
        /// The delete purchase bill items.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<Tuple<int, PharmacyPurchaseBill>> DeletePurchaseBillItems(PharmacyPurchaseBill model);

        /// <summary>
        /// The fetch all retail stores.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<RetailPharmacyModel>> FetchAllRetailStores(RetailPharmacyModel model);

        /// <summary>
        /// The delete retail store async.
        /// </summary>
        /// <param name="retailPharmacyId">
        /// The retail pharmacy id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> DeleteRetailStoreAsync(int retailPharmacyId);

        /// <summary>
        /// The discount on bills.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        ///  The <see cref="Task"/>
        /// </returns>
        Task<int> DiscountOnBill(DiscountBills model);

        /// <summary>
        /// The revoke discounted bill.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        ///  The <see cref="Task"/>
        /// </returns>
        Task<int> RevokeDiscountedBill(DiscountBills model);

        /// <summary>
        /// The add new sales bill async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        ///  The <see cref="Task"/>
        /// </returns>
        Task<Tuple<int, string>> AddNewSalesBillAsync(NewSalesBill model, int locationId);

        /// <summary>
        /// The add new sales bill async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        ///  The <see cref="Task"/>
        /// </returns>
        //Task<int> UpdatePharmacyPurchaseBillAsync(PharmacyPurchaseBill model);

        /// <summary>
        /// The fetch added purchase bill async.
        /// </summary>
        /// <param name="PharmacyRetailStockId">
        /// The pharmacy purchase header id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindPharmacyRetailName(int PharmacyRetailStockId);

        /// <summary>
        /// Fetches the main stock for products in bulk.
        /// </summary>
        /// <param name="productIds">The product ids.</param>
        /// <param name="wareHouseId">The ware house id.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyStockModel>> FetchMainStockForProductsInBulk(string productIds, int? wareHouseId);

        /// <summary>
        /// The fetch Purchase bill which paytype is credit.
        /// </summary>
        /// /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyPurchaseReportBill>> FetchCreditPurchaseBillAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The add new sales bill async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        ///  The <see cref="Task"/>
        /// </returns>
        Task<int> UpdatePurchasePayAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// Corrects the GST calculation in pharmacy sale.
        /// </summary>
        /// <param name="pageSize">Size of the page.</param>
        /// <param name="pageIndex">Index of the page.</param>
        /// <returns></returns>
        Task<int> CorrectGSTCalculationInPharmacySale(int pageSize, int pageIndex);

        /// <summary>
        /// Gets the pharmacy sale bill header counts.
        /// </summary>
        /// <returns></returns>
        Task<int> GetPharmacySaleBillHeaderCounts();

        /// <summary>
        /// Fetches the existing batch numbers.
        /// </summary>
        /// <param name="pharmacyProductId">The pharmacy product identifier.</param>
        /// <param name="locationId"></param>
        /// <returns></returns>
        Task<IEnumerable<string>> FetchExistingBatchNumbers(int pharmacyProductId, int? locationId);

        /// <summary>
        /// Adds the new purchase bill.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddNewPurchaseBill(PurchaseBillHeaderModel model);

        /// <summary>
        /// The fetch purchase bill.
        /// </summary>
        /// <param name="supplierId">
        /// The supplier id.
        /// </param>
        /// <param name="billNumber">
        /// The bill number.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<PurchaseBillHeaderModel> FetchPurchaseBill(int supplierId, string billNumber, int? locationId);

        /// <summary>
        /// Adds the retail store indent asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddRetailStoreIndentAsync(OTRaiseIndentModel model);

        /// <summary>
        /// Fetches the retail indent asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<OTIndentModel>> FetchRetailIndentAsync(OTIndentModel model);

        /// <summary>
        /// Fetches the retail indent detail asynchronous.
        /// </summary>
        /// <param name="model">>The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ProductModel>> FetchRetailIndentDetailAsync(OTIndentModel model);

        /// <summary>
        /// The fetch all retail stores.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<RetailPharmacyModel>> FetchAllRetailStoresOnly(RetailPharmacyModel model);

        /// <summary>
        /// The create retail store.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> CreateRetailStoreAsync(RetailPharmacyModel model);

        /// <summary>
        /// The delete retail store async.
        /// </summary>
        /// <param name="retailPharmacyId">
        /// The retail pharmacy id.
        /// </param>
        /// <param name="modifiedBy">Index of the page.</param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> DeActiveRetailStoreAsync(int retailPharmacyId, int modifiedBy);

        /// <summary>
        /// Fetches all stores settings.
        /// </summary>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyStoreModel>> FetchAllStoresSettings(int? locationId);

        /// <summary>
        /// Adds the retail store details.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddRetailStoreDetails(PharmacyStoreModel model);

        /// <summary>
        /// Applies the store setting in pharmacy.
        /// </summary>
        /// <param name="pharmacyStoreId">The pharmacy store identifier.</param>
        /// <param name="locationId"></param>
        /// <returns></returns>
        Task<int> ApplyStoreSettingInPharmacy(int pharmacyStoreId, int? locationId);

        /// <summary>
        /// Gets the applied setting.
        /// </summary>
        /// <param name="id">The identifier.</param>
        /// <param name="locationId"></param>
        /// <returns></returns>
        Task<PharmacyStoreModel> GetAppliedSetting(int? id, int? locationId);

        /// <summary>
        /// The delete retail store async.
        /// </summary>
        /// <param name="retailPharmacyId">
        /// The retail pharmacy id.
        /// </param>
        /// <param name="modifiedBy">Index of the page.</param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> ToActiveRetailStoreAsync(int retailPharmacyId, int modifiedBy);

        /// <summary>
        /// The delete retail store async.
        /// </summary>
        /// <param name="purchaseHeaderId">
        /// The retail pharmacy id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<PharmaPurchaseBill>> FetchPharmacyCreditPurchaseBillAsync(int purchaseHeaderId);

        /// <summary>
        /// Fetches the pharmacy users retail asynchronous.
        /// </summary>
        /// <param name="accountId">The account identifier.</param>
        /// <param name="pharmacyWareHouseId">The pharmacy ware house identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<RetailWareUser>> FetchPharmacyUsersRetailAsync(int? accountId, int? pharmacyWareHouseId);

        /// <summary>
        /// Fetches the product purchase history asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PurchaseBillHistoryModel>> FetchProductPurchaseHistoryAsync(PurchaseBillHistoryModel model);

        /// <summary>
        /// Fetches the drug asynchronous.
        /// </summary>
        /// <param name="term">The term.</param>
        /// <returns></returns>
        Task<IEnumerable<DrugModel>> FetchDrugAsync(string term);

        /// <summary>
        /// Modifies the medication freq asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyMedicationFreqAsync(MedFrequencyMasterModel model);

        /// <summary>
        /// Fetches the medication freq asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<MedFrequencyMasterModel>> FetchMedicationFreqAsync(MedFrequencyMasterModel model);

        /// <summary>
        /// Changes the active status for med frequency.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ChangeActiveStatusForMedFrequency(MedFrequencyMasterModel model);
       
    }
}
