﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using System;

    using Hims.Shared.UserModels;
    using System.Collections.Generic;
    using Hims.Shared.UserModels.Scan.ScanSubClassification;
    using Hims.Shared.EntityModels;

    /// <summary>
    /// The InternalMedicineService interface.
    /// </summary>
    public interface IScanSubClassificationService
    {



        /// <summary>
        /// The add ob encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(InsertModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(InsertModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<FetchModel>> FetchAll(FetchModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<FetchModel>> FetchAltAsync(FetchModel model);

        /// <summary>
        /// Activates the or deactivate sub classification.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateSubClassification(InsertModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="roomId">
        /// The specialization id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int scanSubClassificationId);
    }
}
