﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using Hims.Shared.Dapper.Attributes;
    using System;

    /// <summary>
    /// The account.
    /// </summary>
    public class ImageModel
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int ImageId { get; set; }

        /// <summary>
        /// Gets or sets the image path.
        /// </summary>
        public string ImagePath { get; set; }

        /// <summary>
        /// Gets or sets the image path.
        /// </summary>
        public string FileName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        ///// <summary>
        ///// Gets or sets the profile image url.
        ///// </summary>
        //public string? ProfileImageUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the image selected.
        /// </summary>
       // public string? IsImageSelected { get; set; }

        /// <summary>
        /// Gets or sets the base 64 profile image.
        /// </summary>
        public string? Base64ProfileImage { get; set; }

        /// <summary>
        /// Gets or sets the fullName.
        /// </summary>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the image type.
        /// </summary>
        public string? ImageType { get; set; }

    }
}