﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class ObEncounterModel
    {
        /// <summary>
        /// Gets or sets the gyn encounter id.
        /// </summary>
        public int OBEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encounter date.
        /// </summary>
        public DateTime OBEncounterDate { get; set; }

        /// <summary>
        /// Gets or sets the vitals.
        /// </summary>
        public string? Vitals { get; set; }

        /// <summary>
        /// Gets or sets the problem list.
        /// </summary>
        public string? ProblemList { get; set; }

        /// <summary>
        /// Gets or sets the procedure form.
        /// </summary>
        public string? ProcedureForm { get; set; }

        /// <summary>
        /// Gets or sets the anc ard closure.
        /// </summary>
        public string? ANCCaredClosure { get; set; }

        /// <summary>
        /// Gets or sets the anc card generation.
        /// </summary>
        public string? ANCCardGeneration { get; set; }

        /// <summary>
        /// Gets or sets the brief ros.
        /// </summary>
        public string? BriefRos { get; set; }

        /// <summary>
        /// Gets or sets the infection history.
        /// </summary>
        public string? InfectionHistory { get; set; }

        /// <summary>
        /// Gets or sets the vaginal examination.
        /// </summary>
        public string? VaginalExamination { get; set; }
        /// <summary>
        /// Gets or sets the breast examination.
        /// </summary>
        public string? BreastExamination { get; set; }

        /// <summary>
        /// Gets or sets the genetic screening.
        /// </summary>
        public string? GeneticScreening { get; set; }

        /// <summary>
        /// Gets or sets the plan of management.
        /// </summary>
        public string? PlanOfManagement { get; set; }

        /// <summary>
        /// Gets or sets the surgeries.
        /// </summary>
        public string? Surgeries { get; set; }

        /// <summary>
        /// Gets or sets the surgeries.
        /// </summary>
        public string? AntinantalRisk { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the complaints.
        /// </summary>
        public string? Complaints { get; set; }

        /// <summary>
        /// Gets or sets the obstetric examination.
        /// </summary>
        public string? ObstetricExamination { get; set; }
        /// <summary>
        /// Gets or sets the order prescription.
        /// </summary>
        public string? OrderPrescription { get; set; }
        /// <summary>
        /// Gets or sets the drug history.
        /// </summary>
        public string? DrugHistory { get; set; }
        /// <summary>
        /// Gets or sets the menstrual history
        /// </summary>
        public string? MenstrualHistory { get; set; }
        /// <summary>
        /// Gets or sets the other
        /// </summary>
        public string? OtherDetail { get; set; }

        /// <summary>
        /// Gets or sets the vte risk.
        /// </summary>
        public string? VTERisk { get; set; }

        /// <summary>
        /// Gets or sets the birth history.
        /// </summary>
        public string? BirthHistory { get; set; }

        /// <summary>
        /// Gets or sets the sga scanning.
        /// </summary>
        public string? SGAScanning { get; set; }

        /// <summary>
        /// Gets or sets the vaccine
        /// </summary>
        public string? Vaccine { get; set; }
        /// <summary>
        /// Gets or sets the postnantal visit
        /// </summary>

        public string? PostnantalVisit { get; set; }
        /// <summary>
        /// Gets or sets the measure
        /// </summary>
        public string? Measure { get; set; }
        /// <summary>
        /// Gets or sets the general examination
        /// </summary>
        public string? GeneralExamination { get; set; }
        /// <summary>
        /// Gets or sets the breech
        /// </summary>
        public string? Breech { get; set; }
        /// <summary>
        /// Gets or sets the anc card
        /// </summary>

        public string? AncCard { get; set; }
        /// <summary>
        /// Gets or sets the covid
        /// </summary>

        public string? Covid { get; set; }

        /// <summary>
        /// Get or sets anaesthesia record
        /// </summary>
        public string? AnaesthesiaRecord { get; set; }
        /// <summary>
        /// Get or sets pre pregnancy counseling
        /// </summary>
        public string? PrepregnancyCounseling { get; set; }
        /// <summary>
        /// Gets or sets the covid
        /// </summary>

        public string? Allergies { get; set; }
        /// <summary>
        /// Gets or sets family history
        /// </summary>
        public string? FamilyHistory { get; set; }
        /// <summary>
        /// Gets or sets is appointment closed
        /// </summary>
        public bool? IsAppointmentClosed { get; set; }
        /// <summary>
        /// Gets or sets out patient management
        /// </summary>
        public string? OutPatientManagement { get; set; }
        /// <summary>
        /// Get or sets pre pregnancy plan
        /// </summary>
        public string? PrePregnancyPlan { get; set; }
        /// <summary>
        /// Get or sets special features
        /// </summary>
        public string? SpecialFeature { get; set; }
        /// <summary>
        /// Get or sets referral form
        /// </summary>
        public string? ReferralForm { get; set; }
        /// <summary>
        /// Get or sets referral order
        /// </summary>
        public string? RefferalOrder { get; set; }
        /// <summary>
        /// Get or sets anc card generation id
        /// </summary>
        public int? ANCCardGenerationId { get; set; }
        /// <summary>
        /// Get or sets admission slip
        /// </summary>
        public string? AdmissionSlip { get; set; }
        /// <summary>
        /// Get or sets mother with epilepsy
        /// </summary>
        public string? MotherWithEpilepsy { get; set; }
        /// <summary>
        /// Get or sets external cephalic version
        /// </summary>
        public string? ExternalCephalicVersion { get; set; }
        /// <summary>
        /// Get or sets external cephalic version
        /// </summary>
        public string? DischargeSummary { get; set; }
        /// <summary>
        /// Get or sets Syndromes
        /// </summary>
        public string? Syndromes { get; set; }
        /// <summary>
        /// Get or sets OPManagement
        /// </summary>
        public string? OPManagement { get; set; }
        /// <summary>
        /// Get or sets patient Id
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Get or sets patient Id
        /// </summary>
        public string? NurseAssessment { get; set; }
        /// <summary>
        /// Get or sets outside tests
        /// </summary>
        public string? OutSideTests { get; set; }
        /// <summary>
        /// Get or sets encrypted appointment id
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }
        /// <summary>
        /// Get or sets AppointmentDate
        /// </summary>
        public DateTime? AppointmentDate { get; set; }

        /// <summary>
        /// Get or sets AppointmentDate
        /// </summary>
        public string? ProviderName { get; set; }
        /// <summary>
        /// Get or sets measure common data
        /// </summary>
        public string? MeasureCommonData { get; set; }
        /// <summary>
        /// Get or sets measure common data
        /// </summary>
        public string? AncCardCloseCommonData { get; set; }
        /// <summary>
        /// Get or sets neonatal assessment form
        /// </summary>
        public string? NeonatalAssessmentForm { get; set; }
        /// <summary>
        /// Get or sets neonatal assessment form
        /// </summary>
        public string? ScanAppointmentDetails { get; set; }
        /// <summary>
        /// Get or sets the induction form
        /// </summary>
        public string? InductionForm { get; set; }
        /// <summary>
        /// Get or sets the delivery form
        /// </summary>
        public string? NormalDeliveryForm { get; set; }
        /// <summary>
        /// Get or sets LSCS form
        /// </summary>
        public string? LSCS { get; set; }
        /// <summary>
        /// Get or sets AdmissionDetails
        /// </summary>
        public string? AdmissionDetails { get; set; }
         
        /// <summary>
        /// Get or sets IUFD Entry form
        /// </summary>
        public string? IUFD { get; set; }


        /// <summary>
        /// Get or sets doctor review form
        /// </summary>
        public string? DoctorsReview { get; set; }
        public string? Reminder { get; set; }

        /// <summary>
        /// Get or sets Risk Category At Adm form
        /// </summary>
        public string? RiskCategoryAtAdm { get; set; }
    }
}