﻿#nullable enable
using System;

namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The coupon filter model.
    /// </summary>
    public class ChargeFilterModel
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int ChargeId { get; set; }


        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int RepeatTypeId { get; set; }



        /// <summary>
        /// Gets or sets the repeat type.
        /// </summary>
        public string RepeatTypeName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int ChargeGroupId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int Cost { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string ChargeName { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }
    }
}
