﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The inventory purchase bill model.
    /// </summary>
    public class InventoryPurchaseBillReportsModel
    {
        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        public string BillDate { get; set; }

        /// <summary>
        /// Gets or sets the supplier name.
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the purchase bill no.
        /// </summary>
        public string PurchaseBillNo { get; set; }

        /// <summary>
        /// Gets or sets the ware house name.
        /// </summary>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the grand total.
        /// </summary>
        public double GrandTotal { get; set; }

        /// <summary>
        /// Gets or sets the taxes.
        /// </summary>
        public double Taxes { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double Discount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double? NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the bill amount.
        /// </summary>
        public double BillAmount { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the due date.
        /// </summary>
        public string DueDate { get; set; }
    }
}
