﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Labs
{
    public class FetchExternalLabTransferUserModel
    {
        /// <summary>
        /// Gets or sets the lab transfer header identifier.
        /// </summary>
        /// <value>
        /// The lab transfer header identifier.
        /// </value>
        public int? ExternalLabTransferId { get; set; }

        /// <summary>
        /// Gets or sets the transfer number.
        /// </summary>
        /// <value>
        /// The transfer number.
        /// </value>
        public string TransferNumber { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public string FromDate { get; set; }

        /// <summary>
        /// Gets or sets the received from date.
        /// </summary>
        /// <value>
        /// The received from date.
        /// </value>
        public string ReceivedFromDate { get; set; }

        /// <summary>
        /// Gets or sets the received to date.
        /// </summary>
        /// <value>
        /// The received to date.
        /// </value>
        public string ReceivedToDate { get; set; }

        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the transferred by.
        /// </summary>
        /// <value>
        /// The transferred by.
        /// </value>
        public int TransferredBy { get; set; }

        /// <summary>
        /// Gets or sets the transferred date.
        /// </summary>
        /// <value>
        /// The transferred date.
        /// </value>
        public DateTime TransferredDate { get; set; }

        /// <summary>
        /// Gets or sets the booked date.
        /// </summary>
        /// <value>
        /// The booked date.
        /// </value>
        public DateTime BookedDate { get; set; }

        /// <summary>
        /// Gets or sets the transfered location identifier.
        /// </summary>
        /// <value>
        /// The transfered location identifier.
        /// </value>
        public int FromLocationId { get; set; }

        /// <summary>
        /// Gets or sets the transfered location.
        /// </summary>
        /// <value>
        /// The transfered location.
        /// </value>
        public string TransferedLocation { get; set; }

        /// <summary>
        /// Gets or sets the name of the transfer by.
        /// </summary>
        /// <value>
        /// The name of the transfer by.
        /// </value>
        public string TransferByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the test code.
        /// </summary>
        /// <value>
        /// The test code.
        /// </value>
        public string TestCode { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        /// <value>
        /// The mobile.
        /// </value>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the name of the doctor.
        /// </summary>
        /// <value>
        /// The name of the doctor.
        /// </value>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the name of the employee.
        /// </summary>
        /// <value>
        /// The name of the employee.
        /// </value>
        public string EmployeeName { get; set; }

        /// <summary>
        /// Gets or sets from location.
        /// </summary>
        /// <value>
        /// From location.
        /// </value>
        public string FromLocation { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the collection date.
        /// </summary>
        /// <value>
        /// The collection date.
        /// </value>
        public DateTime? CollectionDate { get; set; }

        /// <summary>
        /// Gets or sets the barcode date.
        /// </summary>
        /// <value>
        /// The barcode date.
        /// </value>
        public DateTime? BarcodeDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is barcode generated.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is barcode generated; otherwise, <c>false</c>.
        /// </value>
        public bool IsBarcodeGenerated { get; set; }

        /// <summary>
        /// Gets or sets the name of the sample collected by.
        /// </summary>
        /// <value>
        /// The name of the sample collected by.
        /// </value>
        public string SampleCollectedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the barcode generated by.
        /// </summary>
        /// <value>
        /// The name of the barcode generated by.
        /// </value>
        public string BarcodeGeneratedByName { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the created lab location identifier.
        /// </summary>
        /// <value>
        /// The created lab location identifier.
        /// </value>
        public int? CreatedLabLocationId { get; set; }

        /// <summary>
        /// Gets or sets the doctor identifier.
        /// </summary>
        /// <value>
        /// The doctor identifier.
        /// </value>
        public int? DoctorId { get; set; }
        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int? NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int? NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        /// <value>
        /// The date of birth.
        /// </value>
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the color of the row.
        /// </summary>
        /// <value>
        /// The color of the row.
        /// </value>
        public string RowColor { get; set; }

        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int? ProviderId { get; set; }
        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int? RoleId { get; set; }

        /// <summary>
        /// gets or sets the patientId
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// gets or sets the EncryptedId.
        /// </summary>
        public string EncryptedId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabTransferModel"/> is approved.
        /// </summary>
        /// <value>
        ///   <c>true</c> if approved; otherwise, <c>false</c>.
        /// </value>
        public bool? Approved { get; set; }

        /// <summary>
        /// Gets or sets the assigned doctor.
        /// </summary>
        /// <value>
        /// The assigned doctor.
        /// </value>
        public string AssignedDoctor { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int? LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the transferred temperature.
        /// </summary>
        /// <value>
        /// The transferred temperature.
        /// </value>
        public int? TransferredTemperature { get; set; }

        /// <summary>
        /// Gets or sets the transferred temperature comments.
        /// </summary>
        /// <value>
        /// The transferred temperature comments.
        /// </value>
        public string TransferredTemperatureComments { get; set; }

        /// <summary>
        /// Gets or sets the received temperature.
        /// </summary>
        /// <value>
        /// The received temperature.
        /// </value>
        public int? ReceivedTemperature { get; set; }


        /// <summary>Gets or sets the lab booking status identifier.</summary>
        /// <value>The lab booking status identifier.</value>
        public int? LabBookingStatusId { get; set; }

        /// <summary>
        /// Gets or sets the received temperature comments.
        /// </summary>
        /// <value>
        /// The received temperature comments.
        /// </value>
        public string ReceivedTemperatureComments { get; set; }

        /// <summary>
        /// Gets or sets the hold comments.
        /// </summary>
        /// <value>
        /// The hold comments.
        /// </value>
        public string HoldComments { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the sample collection location.
        /// </summary>
        /// <value>
        /// The sample collection location.
        /// </value>
        public string SampleCollectionLocation { get; set; }

        /// <summary>
        /// Gets or sets the technician comment.
        /// </summary>
        /// <value>
        /// The technician comment.
        /// </value>
        public string TechnicianComment { get; set; }

        /// <summary>
        /// Gets or sets the name of the technician.
        /// </summary>
        /// <value>
        /// The name of the technician.
        /// </value>
        public string TechnicianName { get; set; }

        /// <summary>
        /// Gets or sets the technician verification date.
        /// </summary>
        /// <value>
        /// The technician verification date.
        /// </value>
        public DateTime? TechnicianVerificationDate { get; set; }

        /// <summary>
        /// Gets or sets the emergency.
        /// </summary>
        /// <value>
        /// The emergency.
        /// </value>
        public bool? Emergency { get; set; }

        /// <summary>
        /// Gets or sets the type of the booking.
        /// </summary>
        /// <value>
        /// The type of the booking.
        /// </value>
        public string BookingType { get; set; }
        /// <summary>
        /// Creates appointmentid.
        /// </summary>
        /// <value>
        /// The new appointmentid identifier.
        /// </value>
        public int? AppointmentId { get; set; }
        public string EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the lab sample collection detail identifier.
        /// </summary>
        /// <value>
        /// The lab sample collection detail identifier.
        /// </value>
        public int? LabSampleCollectionDetailId { get; set; }

        /// <summary>
        /// Gets or sets the sub sample collected by.
        /// </summary>
        /// <value>
        /// The sub sample collected by.
        /// </value>
        public int? SubSampleCollectedBy { get; set; }

        /// <summary>
        /// Gets or sets the sub barcode generated by.
        /// </summary>
        /// <value>
        /// The sub barcode generated by.
        /// </value>
        public int? SubBarcodeGeneratedBy { get; set; }

        /// <summary>
        /// Gets or sets the sub collection date.
        /// </summary>
        /// <value>
        /// The sub collection date.
        /// </value>
        public DateTime? SubCollectionDate { get; set; }

        /// <summary>
        /// Gets or sets the sub barcode date.
        /// </summary>
        /// <value>
        /// The sub barcode date.
        /// </value>
        public DateTime? SubBarcodeDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [sub is barcode generated].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [sub is barcode generated]; otherwise, <c>false</c>.
        /// </value>
        public bool SubIsBarcodeGenerated { get; set; }

        /// <summary>
        /// Gets or sets the name of the sample.
        /// </summary>
        /// <value>
        /// The name of the sample.
        /// </value>
        public string SampleName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sub sample collected by.
        /// </summary>
        /// <value>
        /// The name of the sub sample collected by.
        /// </value>
        public string SubSampleCollectedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sub barcode generated by.
        /// </summary>
        /// <value>
        /// The name of the sub barcode generated by.
        /// </value>
        public string SubBarcodeGeneratedByName { get; set; }

        /// <summary>
        /// Gets or sets the sub sample collection location.
        /// </summary>
        /// <value>
        /// The sub sample collection location.
        /// </value>
        public string SubSampleCollectionLocation { get; set; }

        /// <summary>
        /// Gets or sets the no of samples collect text.
        /// </summary>
        /// <value>
        /// The no of samples collect text.
        /// </value>
        public string NoOfSamplesCollectText { get; set; }

        /// <summary>
        /// Gets or sets the no of samples collect.
        /// </summary>
        /// <value>
        /// The no of samples collect.
        /// </value>
        public int NoOfSamplesCollect { get; set; }

        /// <summary>
        /// Gets or sets the sub status.
        /// </summary>
        /// <value>
        /// The sub status.
        /// </value>
        public string SubStatus { get; set; }


        /// <summary>Gets or sets from tech.</summary>
        /// <value>From tech.</value>
        public string FromTech { get; set; }

        /// <summary>
        /// Gets or sets the type of the encounter.
        /// </summary>
        /// <value>
        /// The type of the encounter.
        /// </value>
        public string EncounterType { get; set; }

        /// <summary>
        /// Gets or sets the type of the payment.
        /// </summary>
        /// <value>
        /// The type of the payment.
        /// </value>
        public string PaymentType { get; set; }

        /// <summary>
        /// Gets or sets the sample usage.
        /// </summary>
        /// <value>
        /// The sample usage.
        /// </value>
        public string SampleUsage { get; set; }
    }
}
