﻿namespace Hims.Shared.UserModels.Labs
{
    using System.Collections.Generic;

    /// <summary>
    /// The lab parameter observed value model.
    /// </summary>
    public class LabParameterObservedValueModel
    {
        /// <summary>
        /// Gets or sets the lab parameter observed value identifier.
        /// </summary>
        /// <value>
        /// The lab parameter observed value identifier.
        /// </value>
        public long? LabParameterObservedValueId { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab component header identifier.
        /// </summary>
        /// <value>
        /// The lab component header identifier.
        /// </value>
        public int LabComponentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter header identifier.
        /// </summary>
        /// <value>
        /// The lab parameter header identifier.
        /// </value>
        public int LabParameterHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter detail identifier.
        /// </summary>
        /// <value>
        /// The lab parameter detail identifier.
        /// </value>
        public int? LabParameterDetailId { get; set; } // to be removed in future.

        /// <summary>
        /// Gets or sets the observed value.
        /// </summary>
        /// <value>
        /// The observed value.
        /// </value>
        public string ObservedValue { get; set; }
    }

    /// <summary>
    /// The input observed value model.
    /// </summary>
    public class InputObservedValueModel
    {
        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab sample collection detail identifier.
        /// </summary>
        /// <value>
        /// The lab sample collection detail identifier.
        /// </value>
        public int? LabSampleCollectionDetailId { get; set; }

        /// <summary>
        /// Gets or sets the parameters.
        /// </summary>
        /// <value>
        /// The parameters.
        /// </value>
        public List<LabParameterObservedValueModel> Parameters { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }
    }
}
