﻿#nullable enable
namespace Hims.Shared.UserModels.PayU
{
    using System.Collections.Generic;

    /// <summary>
    /// The Payment Status Model
    /// </summary>
    public class PaymentStatusModel
    {
        /// <summary>
        /// Gets or sets status
        /// </summary>
        public long? Status { get; set; }

        /// <summary>
        /// Gets or sets message
        /// </summary>
        public string? Message { get; set; }

        /// <summary>
        /// Gets or sets the msg.
        /// </summary>
        public string? Msg { get; set; }

        /// <summary>
        /// Gets or sets Result
        /// </summary>
        public ResultModel[] Result { get; set; } = null!;

        /// <summary>
        /// Gets or sets error code
        /// </summary>
        public object? ErrorCode { get; set; }

        /// <summary>
        /// Gets or sets response code
        /// </summary>
        public object? ResponseCode { get; set; }

        /// <summary>
        /// Gets or sets the data.
        /// </summary>
        public IList<object>? Details { get; set; }

        /// <summary>
        /// Gets or sets code
        /// </summary>
        public object? Code { get; set; }

        /// <summary>
        /// Gets or sets data
        /// </summary>
        public Data? Data { get; set; }
    }
}
