﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;

    /// <summary>
    /// The Pharmacy product detail model.
    /// </summary>
    public class PharmacyProductDetailModel
    {
        /// <summary>
        /// Gets or sets the pharmacy product detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product detail identifier.
        /// </value>
        public int PharmacyProductDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department identifier.
        /// </value>
        public int? PharmacyDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the name of the rack.
        /// </summary>
        /// <value>
        /// The name of the rack.
        /// </value>
        public string RackName { get; set; }

        /// <summary>
        /// Gets or sets the roq.
        /// </summary>
        /// <value>
        /// The roq.
        /// </value>
        public int ROQ { get; set; }

        /// <summary>
        /// Gets or sets the rol.
        /// </summary>
        /// <value>
        /// The rol.
        /// </value>
        public int ROL { get; set; }
        
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets the modified by Name.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public string ModifiedByName { get; set; }


        /// <summary>
        /// Gets or sets the retail pharmacy identifier.
        /// </summary>
        /// <value>
        /// The retail pharmacy identifier.
        /// </value>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the name of the rack.
        /// </summary>
        /// <value>
        /// The name of the rack.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The pharmacy login role identifier.
        /// </value>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the login account id identifier.
        /// </summary>
        /// <value>
        /// The pharmacy login account id identifier.
        /// </value>
        public int? LoginAccountId { get; set; }


    }
}
